/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl;

import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.servlet.pmod.impl.PanelModelInputSource;
import com.ibm.hwmca.fw.servlet.pmod.impl.ResourceLoader;
import com.ibm.hwmca.fw.servlet.pmod.impl.ResourceLoaderResult;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Locale;

public class ResourceLookupInputSource
implements PanelModelInputSource {
    private static final String TRACE_MASKF = "XPMIRLIF";
    protected String resourceName;
    protected Locale[] locales;
    protected String source = null;
    protected String strata = "Strata:nativePanel";

    public ResourceLookupInputSource(String resourceName, Locale[] locales) {
        Trace.trace(TRACE_MASKF, "ResourceLookupInputSource <ctor> res='" + resourceName + "'");
        this.resourceName = resourceName;
        this.locales = locales;
    }

    public String getStrata() {
        return this.strata;
    }

    public String getSource() {
        return this.source;
    }

    public InputStream getInputStream() throws PanelModelException {
        Trace.trace(TRACE_MASKF, "ResourceLookupInputSource getInputStream()");
        ResourceLoaderResult resourceLoaderResult = ResourceLoader.getMarkupResource(this.resourceName, this.locales, "hmcser");
        if (resourceLoaderResult != null) {
            Trace.trace(TRACE_MASKF, "ResourceLookupInputSource getInputStream() working with serialized panel.");
            this.strata = "Strata:serializedPanel";
            this.source = resourceLoaderResult.getSource();
            return new BufferedInputStream(resourceLoaderResult.getStream(), 8192);
        }
        resourceLoaderResult = ResourceLoader.getMarkupResource(this.resourceName, this.locales, "hmcml");
        if (resourceLoaderResult == null) {
            throw new PanelModelException("Unable to locate specified resource: '" + this.resourceName + "'");
        }
        Trace.trace(TRACE_MASKF, "ResourceLookupInputSource getInputStream() working with hmcml panel.");
        this.source = resourceLoaderResult.getSource();
        return resourceLoaderResult.getStream();
    }
}

